function MarkByHand(Mode)

global  vImarisApplication ImarisCell fInfoLSM ImInfo guiInfo guiList

%{
function [guiInfo,fInfoLSM,guiList]=MarkByHand(guiList,guiInfo,fInfoLSM,YZ,AverageChan,XY)
Jan 2011
Gerhard Hoch
InnerEarLab, Dept. of Otolaryngology and Center for Molecular Physiology of the Brain,
University of Gttingen, 37099 Gttingen, Germany


fInfoLSM.MbyHand(fInfoLSM.chanSynapse).isNrSynapse
fInfoLSM.MbyHand(fInfoLSM.chanSynapse).SynXpos          in Pixel
fInfoLSM.MbyHand(fInfoLSM.chanSynapse).SynYpos
fInfoLSM.MbyHand(fInfoLSM.chanSynapse).SynZpos
fInfoLSM.MbyHand(fInfoLSM.chanSynapse).SizePixelSyn

fInfoLSM.Syn2CellVector(fInfoLSM.chanSynapse).isCell
fInfoLSM.Syn2CellVector(fInfoLSM.chanSynapse).distance
fInfoLSM.Syn2CellVector(fInfoLSM.chanSynapse).XperCell
fInfoLSM.Syn2CellVector(fInfoLSM.chanSynapse).YperCell
fInfoLSM.Syn2CellVector(fInfoLSM.chanSynapse).ZperCell
fInfoLSM.Syn2CellVector(fInfoLSM.chanSynapse).xPx
fInfoLSM.Syn2CellVector(fInfoLSM.chanSynapse).yPx
fInfoLSM.Syn2CellVector(fInfoLSM.chanSynapse).zPx
%}

%if isfield(guiInfo,'MarkByHandfig') if guiInfo.MarkByHandfig>0 close(guiInfo.MarkByHandfig); end; end;
%guiInfo.MarkByHandfig=figure('Position',guiInfo.uiPos.MarkByHandFig,'name','MarkByHand','NumberTitle','off','menubar', 'none','WindowButtonMotionFcn',[''],'DeleteFcn',['guiInfo.MarkByHandfig=[];']); [fInfoLSM,guiInfo]=setuimenuEditByHand(guiList,guiInfo,fInfoLSM);

%ImInfo.ImDataXYZ

if Mode==1
  guiInfo.DoBatch=0; guiInfo.DoExcel=1;
  fInfoLSM.file=char(vImarisApplication.GetCurrentFileName);
  if strfind(guiInfo.IsVers,'R2016a')>0
    display('->R2016a');[guiInfo.pathstr,guiInfo.name,guiInfo.ext]=fileparts(fInfoLSM.file);  
  else
    display(['->' guiInfo.IsVers]);[guiInfo.pathstr,guiInfo.name,guiInfo.ext,guiInfo.versn]=fileparts(fInfoLSM.file);
  end
  fInfoLSM.FileXLS=fullfile(guiInfo.pathstr,[guiInfo.name 'MbHand Result']);
  fInfoLSM.FilePDF=fullfile(guiInfo.pathstr,[guiInfo.name 'MbHand Spots']);
  fInfoLSM.FileTIF=fullfile(guiInfo.pathstr,[guiInfo.name 'MbHand Spots']);
  XT3dMarkByHandReadImage;    
  XT3dMarkByHandReadSurpass; 
  XT3dMarkByHandSetParam;
end;  

guiInfo.uiMeasureByHandClear=uicontrol('Style','pushbutton','String','clear Syn','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandClear,'Callback',['MarkByHandCallbackClear;']);
guiInfo.uiMeasureByHandClearAll=uicontrol('Style','pushbutton','String','clear allSyn','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandClearAll,'Callback',['MarkByHandCallbackClearAll;']);
guiInfo.uiMeasureByHandLoad=uicontrol('Style','pushbutton','String','load autoSeg','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandLoad,'Callback',['MarkByHandCallbackLoadAutoSeg;']);

guiInfo.uiMeasureByHandSave=uicontrol('Style','pushbutton','String','save','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandSave,'Callback',['MarkByHandCallbackSave;']);

ChanList=[];for iList=1:fInfoLSM.AnzChan ChanList{iList}=['Spots' num2str(iList)]; end;
guiInfo.uiMeasureByHandLoadChan=uicontrol('Style','Listbox','String',ChanList,'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandLoadChan,'Value',1,'Callback',['MarkByHandCallbackLoadAutoSeg;']);
guiInfo.uiMeasureByHandLoadNrSyn=uicontrol('Style','Text','String',['NrSyn : - '],'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandLoadNrSyn);

fInfoLSM.chanSynRefROI=1;guiInfo.uiMeasureByHandChanSynRef=uicontrol('Style','Listbox','String',ChanList,'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandChanSynRef,'Value',fInfoLSM.chanSynRefROI,'Callback',['MarkByHandCallbackChanSynRef']);
guiInfo.uiMeasureByHandSynRef=uicontrol('Style','Text','String',['SynRef'],'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandSynRef);
guiInfo.uiMeasureByHandSynRefNr=uicontrol('Style','Text','String',['-'],'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandSynRefNr);
ImInfo.MeasureByHandSynRefROIdist=0.7; guiInfo.uiMeasureByHandSynRefROIdist=uicontrol('Style', 'edit', 'String',num2str(ImInfo.MeasureByHandSynRefROIdist),'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandSynRefROIdist,'Callback',['MarkByHandCallbackSynRefROIdist']);
guiInfo.uiMeasureByHandDoSynRefROI=uicontrol('Style','pushbutton','String','delSynRefROI','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandDoSynRefROI,'Callback',['MarkByHandCallbackDoChanSynRefROI;']);

ModeList=[];ModeList{1}=[' display']; ModeList{2}=['   add  '];ModeList{3}=['  GoTo  ']; guiInfo.MeasureByHandGraficMode=1;
guiInfo.uiMeasureByHandGraficMode=uicontrol('Style','Listbox','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandGraficMode,'String',ModeList,'Value',1,'Callback',['MarkByHandCallbackGraficMode;']);

if ~isfield(fInfoLSM,'MeasureByHandAddCalcCenter') fInfoLSM.MeasureByHandAddCalcCenter=0; end;
guiInfo.uiMeasureByHandAddCalcCenter=uicontrol('Style','checkbox','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandAddCalcCenter,'String','CalCenter','Value',fInfoLSM.MeasureByHandAddCalcCenter,'Visible','off','Callback',['MarkByHandCallbackAddCalcCenter;']);

if ~isfield(fInfoLSM,'MeasureByHandROIx') fInfoLSM.MeasureByHandROIx=2; end; 
guiInfo.uiMeasureByHandROIXStr=uicontrol('Style','Text','String','+/-roiX','Units','normalized','Position',guiInfo.uiPos.MarkByHand.roiXStr,'Visible','off'); 
guiInfo.uiMeasureByHandROIX=uicontrol('Style','edit','Units','normalized','Position',guiInfo.uiPos.MarkByHand.roiX,'string',num2str(fInfoLSM.MeasureByHandROIx),'Callback',['fInfoLSM.MeasureByHandROIx=str2num(get(guiInfo.uiMeasureByHandROIX,''String''));'],'Visible','off'); 
if ~isfield(fInfoLSM,'MeasureByHandROIy') fInfoLSM.MeasureByHandROIy=2; end; 
guiInfo.uiMeasureByHandROIYStr=uicontrol('Style','Text','String','+/-roiY','Units','normalized','Position',guiInfo.uiPos.MarkByHand.roiYStr,'Visible','off'); 
guiInfo.uiMeasureByHandROIY=uicontrol('Style','edit','Units','normalized','Position',guiInfo.uiPos.MarkByHand.roiY,'string',num2str(fInfoLSM.MeasureByHandROIy),'Callback',['fInfoLSM.MeasureByHandROIy=str2num(get(guiInfo.uiMeasureByHandROIY,''String''));'],'Visible','off'); 
if ~isfield(fInfoLSM,'MeasureByHandROIz') fInfoLSM.MeasureByHandROIz=1; end; 
guiInfo.uiMeasureByHandROIZStr=uicontrol('Style','Text','String','+/-roiZ','Units','normalized','Position',guiInfo.uiPos.MarkByHand.roiZStr,'Visible','off'); 
guiInfo.uiMeasureByHandROIZ=uicontrol('Style','edit','Units','normalized','Position',guiInfo.uiPos.MarkByHand.roiZ,'string',num2str(fInfoLSM.MeasureByHandROIz),'Callback',['fInfoLSM.MeasureByHandROIz=str2num(get(guiInfo.uiMeasureByHandROIZ,''String''));'],'Visible','off'); 

guiInfo.doRGB=0;RGBList=[]; RGBList{1}=['none']; for ii=1:fInfoLSM.AnzChan RGBList{ii+1}=['chan' num2str(ii)]; end;
if ~isfield(fInfoLSM,'MeasureByHandSynProj') for ii=1:fInfoLSM.AnzChan fInfoLSM.MeasureByHandSynProj(ii)=1; end; end; 
guiInfo.RGBstr=['R ';'G ';'B ';'bw'];
for ii=1:4 
  guiInfo.uiMeasureByHandRef(ii)=uicontrol('Style','Listbox','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandRef(ii).ispos,'String',RGBList,'Value',fInfoLSM.MeasureByHandSynProj(1),'Callback',['MarkByHandRefreshPlot;']);  
  guiInfo.uiMeasureByHandRefText(ii)=uicontrol('Style','Text','String',guiInfo.RGBstr(ii,:),'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandRefText(ii).ispos);
end;

guiInfo.MeasureByHandCalIntensROI=0; guiInfo.uiMeasureByHandCalIntensROI=uicontrol('Style','Checkbox','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandCalIntensROI,'Value',guiInfo.MeasureByHandCalIntensROI,'String','RGB-contrast','Callback',['MarkByHandCallbackCalIntensROI;']);
for i=1:3 guiInfo.MeasureByHandCalIntensSlider(i)=1; guiInfo.uiMeasureByHandCalIntensSlider(i)=uicontrol('Style','slider','Min',0.2,'Max',1.2,'SliderStep',[0.01 0.1],'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandCalIntensSlider(i).ispos,'Value',guiInfo.MeasureByHandCalIntensSlider(i),'Visible','off','Callback',['MarkByHandCallbackCalIntensSlider;']);end;

guiList.uiListBoxMeasureByHand=uicontrol('Style','Listbox','Units','normalized','Position',guiInfo.uiPos.MarkByHand.ListBoxMeasureByHand,'FontSize',10,'Callback',['MarkByHandCallbackListBox;']);

guiInfo.MeasureByHandSynProj=1;
guiInfo.uiMeasureByHandSynProj=uicontrol('Style','Checkbox','Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandSynProj,'Value',guiInfo.MeasureByHandSynProj,'String','zProjection','Callback',['MarkByHandSliderZ;']);

guiInfo.sliderPicSynapse=1;
guiInfo.uiMeasureByHandPicZ=uicontrol('Style','slider','Min',1,'Max',fInfoLSM.NrSclicesZ,'Value',guiInfo.sliderPicSynapse,'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandPicZ,'SliderStep',[1/fInfoLSM.NrSclicesZ 1/fInfoLSM.NrSclicesZ],'Callback',['MarkByHandSliderZ;']);
guiInfo.uiMeasureByHandPicZText=uicontrol('Style','Text','String',int2str(guiInfo.sliderPicSynapse),'Units','normalized','Position',guiInfo.uiPos.MarkByHand.MeasureByHandPicZText);

ImInfo.ImDataXYZ=flipdim(ImInfo.ImDataXYZ,4);    % ImInfo.ImDataXYZ(vTime,vChannel,x,y,z)

if strfind(guiInfo.IsVers,'R2013b')>0
else    
  iptsetpref('ImshowBorder','tight');
end

guiInfo.MarkByHandfigYZ=figure('Position',guiInfo.uiPos.MarkByHandFigYZ,'NumberTitle','off','name','MarkByHandYZ'); % setUIMenuEditByHand;
pic=[]; pic(:,:)=ImInfo.ImDataXYZ(1,fInfoLSM.chanSynapse,1,:,:);
subplot(1,3,2);guiInfo.MbyHand.YZpic=imshow(pic,[]); guiInfo.MbyHand.YZgca=gca; colormap(gray); daspect([1/fInfoLSM.YtoZ 1 1]); 
if strfind(guiInfo.IsVers,'R2016a')>0
else  
  set(guiInfo.MbyHand.YZpic,'EraseMode','none'); 
end;  
hold on; guiInfo.isYZpicPt=plot(1,1); set(guiInfo.isYZpicPt,'XData',[],'YData',[],'Marker','x','MarkerSize',20,'Color','red'); hold off;

guiInfo.MarkByHandfigXY=figure('Position',guiInfo.uiPos.MarkByHandFigXY,'NumberTitle','off','name','MarkByHandXY'); 
pic=[]; pic(:,:)=mean(ImInfo.ImDataXYZ(1,fInfoLSM.chanSynapse,:,:,:),5); 
guiInfo.MbyHand.XYpic=imshow(pic',[]); guiInfo.MbyHand.XYgca=gca; daspect([1 1 1]); colormap(gray); 

if strfind(guiInfo.IsVers,'R2016a')>0
else  
  set(guiInfo.MbyHand.XYpic,'EraseMode','none');
end
  

MarkByHandCallbackLoadAutoSeg;
